export class CustomEntityBucketItems {
  static parentId = null;

  /**
   * Get every Bucket variation.
   * @returns A array with all custom bucket identifier
   */
  static names() {
    return Object.getOwnPropertyNames(new this());
  }

  /**
   * Get a specific custom bucket identifier.
   * @param {number} value The variation value.
   * @returns A custom bucket identifier.
   */
  static getByValue(value) {
    return this.names().find((bucket) => new this()[bucket] === value);
  }

  /**
   * Get the variation id of a custom bucket.
   * @param {string} key The custom bucket identifier.
   * @returns The custom bucket variation value.
   */
  static getVariation(key) {
    return new this()[key];
  }
}
